{ Test program to load the employee table from the demo database hosted at www.nozicle.com/demodb.
  Note that the demo database is read only - the db_mysql_update.php script has not been installed }

unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBCtrls, ExtCtrls, Grids, DBGrids, Db, NozicleComponents,
  BaseDataset, ComCtrls, EditEmployeeForm, LoginForm;

type
  TfmMain = class(TForm)
    NozicleWebConnection: TNozicleWebConnection;
    DataSource: TDataSource;
    DBGrid: TDBGrid;
    Panel1: TPanel;
    buCloseDatabase: TButton;
    NozicleDataset: TNozicleDataset;
    StatusBar: TStatusBar;
    StaticText1: TStaticText;
    buOpenDatabaseSQL: TButton;
    buEdit: TButton;
    buAdd: TButton;
    procedure buCloseDatabaseClick(Sender: TObject);
    procedure buOpenDatabaseSQLClick(Sender: TObject);
    procedure buEditClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure UpdateStatus;
    procedure CheckControls;
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation

{$R *.DFM}

procedure TfmMain.CheckControls;
begin
  buEdit.Enabled := NozicleDataset.Active;
  buAdd.Enabled := NozicleDataset.Active;
end;

procedure TfmMain.UpdateStatus;
begin
  if NozicleDataset.ErrorMessage <> '' then begin
    LoggedIn := FALSE;
    ShowMessage(NozicleDataset.ErrorMessage);
    exit;
  end;
  LoggedIn := TRUE;
  StatusBar.Panels[0].Text := IntToStr(NozicleDataset.DataSetSize)+' Bytes (compressed)'; // no of bytes downloaded from server
  StatusBar.Panels[1].Text := IntToStr(NozicleDataset.DownloadTime)+' mSecs'; // time taken to download
  StatusBar.Panels[2].Text := IntToStr(NozicleDataset.RecordCount)+' rows';  // no of rows in the table
  CheckControls;
end;

procedure TfmMain.buCloseDatabaseClick(Sender: TObject);
begin
  NozicleDataset.Active := FALSE;
  LoggedIn := FALSE;
end;

procedure TfmMain.buOpenDatabaseSQLClick(Sender: TObject);
begin
  if not LoggedIn then begin
    if not Login then exit;
    NozicleWebConnection.UserLogin := fmLogin.edLogin.Text;
    NozicleWebConnection.UserPassword := fmLogin.edPassword.Text;
    if fmLogin.cbLocalHost.Checked then begin
      NozicleWebConnection.URL := 'http://localhost';
      NozicleWebConnection.SelectScriptName := 'employee/db_mysql.php';
      NozicleWebConnection.UpdateScriptName := 'employee/db_mysql_update.php';
    end
    else begin
      NozicleWebConnection.URL := 'http://www.nozicle.com';
      NozicleWebConnection.SelectScriptName := 'demodb/db_mysql_employee.php';
      NozicleWebConnection.UpdateScriptName := 'demodb/db_mysql_update.php';
    end;
  end;
  NozicleDataset.Active := FALSE;
  NozicleDataset.DoSQL := TRUE;
  NozicleDataset.SQL := 'select concat(firstname," ",lastname) as Name, '+
                        'empno, '+
                        'phoneext, '+
                        'hiredate, '+
                        'salary from employee '+
                        'order by name';
  NozicleDataset.Active := TRUE;
  UpdateStatus;
end;

procedure TfmMain.buEditClick(Sender: TObject);
begin
  if NozicleDataset.FieldByName('EmpNo').AsString = '' then
    exit;
  Caption := 'Loading Employee...';
  if EditEmployee(NozicleDataset.FieldByName('EmpNo').AsString) then
    buOpenDatabaseSQLClick(nil);
end;

procedure TfmMain.FormCreate(Sender: TObject);
begin
  CheckControls;
end;

end.
